/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.dialogs;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.ui.util.UIUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InputMessageDialog
extends MessageDialog {
    protected static final String LIST = "list";
    protected static final String CHECKBOX = "checkbox";
    protected static final String PASSWORD = "password";
    protected static final String INPUT = "input";
    protected static final String CONFIRMATION = "confirm";
    protected static final String NAME = "name";
    protected static final String TYPE = "type";
    protected static final String CHOICES = "choices";
    protected static final String MESSAGE = "message";
    protected static final String VALUE = "value";
    protected static final String DEFAULT = "default";
    private List<Object> input;
    private String inputType;
    private String userInput;
    private String dialogMessage;
    private ArrayNode values;

    public InputMessageDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
    }

    public InputMessageDialog(JsonNode questionNode, String title, String description) {
        super(UIUtils.getActiveShell(), title, null, description, 5, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.dialogMessage = questionNode.path(MESSAGE).asText();
        this.inputType = questionNode.path(TYPE).asText();
        this.values = (ArrayNode)questionNode.path(CHOICES);
        this.input = new ArrayList<Object>();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createMessageArea(composite);
        this.createInput(composite);
        return composite;
    }

    private void createInput(Composite composite) {
        new Label(composite, 0);
        Composite parent = new Composite(composite, 0);
        parent.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(2).create());
        Label label = new Label(parent, 0);
        label.setText(this.dialogMessage);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, false).hint(-1, 25).applyTo((Control)label);
        Composite valueComp = new Composite(parent, 0);
        valueComp.setLayout((Layout)new FillLayout(256));
        if (INPUT.equals(this.inputType) || PASSWORD.equals(this.inputType)) {
            int flags = 2048;
            if (PASSWORD.equals(this.inputType)) {
                flags |= 0x400000;
            }
            Text t = new Text(valueComp, flags);
            this.input.add(t);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(this.convertHorizontalDLUsToPixels(160), 25).applyTo((Control)valueComp);
        } else if (CHECKBOX.equals(this.inputType)) {
            for (JsonNode value : this.values) {
                Button b = new Button(valueComp, 32);
                b.setText(value.asText());
                this.input.add(b);
            }
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)valueComp);
        } else if (LIST.equals(this.inputType)) {
            Combo l = new Combo(valueComp, 0);
            ComboViewer combo = new ComboViewer(l);
            this.input.add(combo);
            combo.setContentProvider((IContentProvider)new ArrayContentProvider(){

                public Object[] getElements(Object inputElement) {
                    if (inputElement instanceof ArrayNode) {
                        ArrayNode arrayNode = (ArrayNode)inputElement;
                        Object[] names = new JsonNode[arrayNode.size()];
                        int i = 0;
                        for (JsonNode node : arrayNode) {
                            names[i++] = node;
                        }
                        return names;
                    }
                    return super.getElements(inputElement);
                }
            });
            combo.setInput((Object)this.values);
            combo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof ObjectNode) {
                        String name = ((ObjectNode)element).path(InputMessageDialog.NAME).asText();
                        if (StringUtil.isEmpty((String)name)) {
                            return ((ObjectNode)element).asText();
                        }
                        return name;
                    }
                    if (element instanceof JsonNode) {
                        return ((JsonNode)element).asText();
                    }
                    return element.toString();
                }
            });
            combo.setSelection((ISelection)new StructuredSelection((Object)this.values.get(0)));
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)valueComp);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            Object selectedElement;
            ISelection selection;
            Object firstElement = CollectionsUtil.getFirstElement(this.input);
            if (firstElement instanceof Text) {
                this.userInput = ((Text)firstElement).getText();
            } else if (firstElement instanceof Button) {
                for (Object b : this.input) {
                    if (!((Button)b).getSelection()) continue;
                    this.userInput = ((Button)b).getText();
                    break;
                }
            } else if (firstElement instanceof ComboViewer && !(selection = ((ComboViewer)firstElement).getSelection()).isEmpty() && selection instanceof IStructuredSelection && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof JsonNode) {
                this.userInput = ((JsonNode)selectedElement).path(VALUE).asText();
            }
        }
        super.buttonPressed(buttonId);
    }

    public Object getValue() {
        return "\"" + this.userInput + "\"";
    }
}

